/*
 * Decompiled with CFR 0.152.
 */
package net.forixaim.battle_arts.core_assets.skills.battlestyle.common.advanced;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.forixaim.battle_arts.core_assets.capabilities.styles.SamuraiStyles;
import net.forixaim.battle_arts.core_assets.skills.BattleArtsDataKeys;
import net.forixaim.bs_api.battle_arts_skills.battle_style.BattleStyle;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPPlayAnimation;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class Ronin
extends BattleStyle {
    private static final UUID EVENT_UUID = UUID.fromString("55220562-9883-4a57-bd92-a6257127cb66");
    private boolean weaponChecked = false;

    public Ronin(BattleStyle.Builder<? extends Skill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            container.getDataManager().setDataSync((SkillDataKey)BattleArtsDataKeys.BATTO_SHEATH.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            ((ServerPlayerPatch)event.getPlayerPatch()).modifyLivingMotionByCurrentItem();
            container.getSkill().setConsumptionSynchronize((ServerPlayerPatch)event.getPlayerPatch(), 0.0f);
            container.getSkill().setStackSynchronize((ServerPlayerPatch)event.getPlayerPatch(), 0);
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID, event -> this.onReset(container));
    }

    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID);
    }

    public boolean shouldDraw(SkillContainer container) {
        return container.getExecuter().getHoldingItemCapability(InteractionHand.MAIN_HAND).getWeaponCategory() == CapabilityItem.WeaponCategories.UCHIGATANA;
    }

    private ResourceLocation battojutsuReady(SkillContainer container) {
        return (Boolean)container.getDataManager().getDataValue((SkillDataKey)BattleArtsDataKeys.BATTO_SHEATH.get()) != false ? new ResourceLocation("battle_arts", "textures/gui/skills/battojutsu_sheathed.png") : new ResourceLocation("battle_arts", "textures/gui/skills/battojutsu.png");
    }

    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y) {
        String Cooldown_Time;
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        guiGraphics.m_280411_(this.battojutsuReady(container), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        float CD = container.getResource();
        String string = Cooldown_Time = container.getMaxResource() - CD > 100.0f ? String.format("%.0f", Float.valueOf(container.getMaxResource() - CD)) : String.format("%.1f", Float.valueOf(container.getMaxResource() - CD));
        if (container.getMaxResource() - CD != 5.0f) {
            guiGraphics.drawString(gui.font, Cooldown_Time, x + 4.0f, y + 6.0f, 0xFFFFFF, true);
        }
        poseStack.m_85849_();
    }

    public void onReset(SkillContainer container) {
        PlayerPatch executer = container.getExecuter();
        if (!executer.isLogicalClient() && ((Boolean)container.getDataManager().getDataValue((SkillDataKey)BattleArtsDataKeys.BATTO_SHEATH.get())).booleanValue()) {
            ServerPlayerPatch playerpatch = (ServerPlayerPatch)executer;
            container.getDataManager().setDataSync((SkillDataKey)BattleArtsDataKeys.BATTO_SHEATH.get(), (Object)false, (ServerPlayer)playerpatch.getOriginal());
            playerpatch.modifyLivingMotionByCurrentItem();
            container.getSkill().setConsumptionSynchronize(playerpatch, 0.0f);
        }
    }

    public void setConsumption(SkillContainer container, float value) {
        PlayerPatch executer = container.getExecuter();
        if (!(executer.isLogicalClient() || executer.getHoldingItemCapability(InteractionHand.MAIN_HAND).getStyle((LivingEntityPatch)executer) != SamuraiStyles.SAMURAI_UCHIGATANA && executer.getHoldingItemCapability(InteractionHand.MAIN_HAND).getStyle((LivingEntityPatch)executer) != SamuraiStyles.SAMURAI_UCHIGATANA_SHEATHED || !(container.getMaxResource() < value) || ((Boolean)container.getDataManager().getDataValue((SkillDataKey)BattleArtsDataKeys.BATTO_SHEATH.get())).booleanValue())) {
            ServerPlayer serverPlayer = (ServerPlayer)executer.getOriginal();
            container.getDataManager().setDataSync((SkillDataKey)BattleArtsDataKeys.BATTO_SHEATH.get(), (Object)true, serverPlayer);
            ((ServerPlayerPatch)container.getExecuter()).modifyLivingMotionByCurrentItem();
            SPPlayAnimation msg3 = new SPPlayAnimation(Animations.BIPED_UCHIGATANA_SCRAP, serverPlayer.m_19879_(), 0.0f);
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf((Object)msg3, (ServerPlayer)serverPlayer);
        }
        super.setConsumption(container, value);
    }

    public float getCooldownRegenPerSecond(PlayerPatch<?> player) {
        return ((Player)player.getOriginal()).m_6117_() && player.getHoldingItemCapability(InteractionHand.MAIN_HAND).getWeaponCategory() == CapabilityItem.WeaponCategories.UCHIGATANA ? 0.0f : 1.0f;
    }
}

